
on createBundlesFolder()
	tell application "Finder"
		try
			set theDestinationFolder to path to library folder from user domain
			set theDestinationFolder to (theDestinationFolder as string) & "Mail:"
			set theResult to make new folder at (theDestinationFolder as alias) with properties {name:"Bundles"}
			return theResult is not missing value
		on error number num
			return num is -48
		end try
	end tell
end createBundlesFolder

on deleteFile(thePath)
	tell application "Finder"
		try
			set theFile to thePath as POSIX file
			set theResult to delete theFile
			return theResult is not missing value
		on error number num
			return false
		end try
	end tell
end deleteFile

on copyFile(theSourcePath,theDestinationFolder)
	tell application "Finder"
		try
			set theResult to duplicate (theSourcePath as POSIX file) to (theDestinationFolder as POSIX file) with replacing and exact copy
			return theResult is not missing value
		on error number num
			return false
		end try
	end
end copyFile

on movePlugin(theSourcePath)
	tell application "Finder"
		try
			set theDestinationFolder to path to library folder from user domain
			set theDestinationFolder to (theDestinationFolder as string) & "Mail:Bundles:"
			set theResult to move ((POSIX file theSourcePath) as alias) to (theDestinationFolder as alias)
			return theResult is not missing value
		on error msg
			return false
		end try
	end tell
end copyPlugin
